(
	-- Standard Material (Approximation)

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"480295f3-8b79-4622-b7ef-84e86073d73c"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.diffuseMap != undefined and mtl.diffuseMapEnable do (
				append res #("diffuseMap",      mtl.diffuseMap)
				append res #("diffuseMapAlpha", mtl.diffuseMap, "alpha")
			)

			-- some subshaders have this, others don't. We used it when it's there....
			if hasProperty mtl "diffuseLevelMap" do
			(
				if mtl.diffuseLevelMap != undefined and mtl.diffuseLevelMapEnable do 
					append res #("diffuseLevelMap", mtl.diffuseLevelMap, "resultFloat")
			)

			if mtl.opacityMap != undefined and mtl.opacityMapEnable do (
				append res #("opacityMap",      mtl.opacityMap, "resultFloat")
			)

			if mtl.bumpMap != undefined and mtl.bumpMapEnable do (
				append res #("bump",            mtl.bumpMap,    "normalPerturb", 1)
			)

			-- some subshaders have this, others don't. We used it when it's there....
			if hasProperty mtl "Specular" do
			(
				if mtl.specularMap != undefined and mtl.specularMapEnable do (
					append res #("specularMap",      mtl.specularMap)
				)
				if mtl.specularLevelMap != undefined and mtl.specularLevelMapEnable do (
					append res #("specularLevelMap", mtl.specularLevelMap, "resultFloat")
				)
				if mtl.glossinessMap != undefined and mtl.glossinessMapEnable do (
					append res #("glossinessMap",    mtl.glossinessMap,    "resultFloat")
				)
			)


			if hasProperty mtl "selfillumMap" do
			(
				if mtl.selfIllumMap != undefined and mtl.selfillumMapEnable do (
					append res #("selfIllumMap",      mtl.selfillumMap)
				)
			)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			-- Diffuse
			append res #("diffuse",           mtl.diffuse)

			-- Diffuse map knobs
			append res #("diffuseMapAmount",  mtl.diffuseMapAmount / 100.0)
			append res #("diffuseMapAlpha",   0.0) 

			-- some subshaders have this, others don't. We used it when it's there....
			if (hasProperty mtl "diffuseLevel") then (
				append res #("diffuseLevel",      mtl.diffuseLevel / 100.0)
			)
			else
			(
				append res #("diffuseLevel",      1.0)
			)

			-- some subshaders have this, others don't. We used it when it's there....
			if (hasProperty mtl "diffuseLevelMap") then (
				if mtl.diffuseLevelMap != undefined and mtl.diffuseLevelMapEnable then (
					append res #("diffuseLevelMapAmount",      mtl.diffuseLevelMapAmount / 100.0)
				)
				else
				(
					append res #("diffuseLevelMapAmount",      0.0)
				)
			)
			else
			(
				append res #("diffuseLevelMapAmount",      0.0)
			)


			-- some subshaders have this, others don't. We used it when it's there....
			if hasProperty mtl "Specular" then
			(
				append res #("specular",      mtl.specular)

				if mtl.specularMap != undefined and mtl.specularMapEnable then (
					append res #("specularMapAmount",      mtl.specularMapAmount / 100.0)
				)
				else
				(
					append res #("specularMapAmount",      0.0)
				)

				append res #("specularLevel",  mtl.specularLevel  / 100.0)

				if mtl.specularLevelMap != undefined and mtl.specularLevelMapEnable then (
					append res #("specularLevelMapAmount", mtl.specularLevelMapAmount / 100.0)
				)
				else
				(
					append res #("specularLevelMapAmount", 0.0)
				)

				append res #("glossiness",  mtl.glossiness  / 100.0)

				if mtl.glossinessMap != undefined and mtl.glossinessMapEnable then (
					append res #("glossinessMapAmount", mtl.glossinessMapAmount / 100.0)
				)
				else
				(
					append res #("glossinessMapAmount", 0.0)
				)
			)
			else
			(
				-- No speculars
				append res #("specularLevel", 0.0)				
			)

			local emissive = false

			if hasProperty mtl "selfillumAmount" then
			(
				if mtl.selfIllumMap != undefined and mtl.selfillumMapEnable then (
					append res #("selfIllumMapAmount",      mtl.selfillumMapAmount / 100.0)
					emissive = true
				)
				else
				(
					append res #("selfIllumMapAmount",      0.0)
				)

				if mtl.useSelfIllumColor then (
					append res #("selfIllum",   mtl.selfIllumColor)
					emissive = true
				)
				else
				(
					local x = (mtl.selfIllumAmount / 100.0) * 256.0

					if x > 0 do emissive = true

					append res #("selfIllum",   (color x x x))
				)

				append res #("useSelfIllumColor", mtl.useSelfIllumColor)
			)
			else
			(
				append res #("selfIllum",           (color 0 0 0))
				append res #("selfIllumMapAmount",  0.0)
				append res #("useSelfIllumColor",   false)
			)

			-- Flag emissive or not

			-- Commenting this out to fixx MAXX-48099, but leaving it here
			-- hoping it can be revisited in the future. The problem: The new ART makes objects
			-- non-shadow-casting if the emissive flag is set
			-- append res #("att:emissive", emit)
			
			-- Opacity
			append res #("opacity",           mtl.opacity / 100.0)
			append res #("opacityMap",        mtl.opacity / 100.0)

			-- Opacity map knobs
			if mtl.opacityMap != undefined and mtl.opacityMapEnable then 			
				append res #("opacityMapAmount",  mtl.opacityMapAmount / 100.0)
			else
				append res #("opacityMapAmount",  0.0)
			
			-- Bump map knobs
			append res #("bumpAmount",  mtl.bumpMapAmount / 100.0)

			res
		)
	)

	AMGData()	
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCTIA036NgqpWrGt+OkPC4/1bKRwIvWkVgy
-- k4piZ95DAPZPRXwjyZh+GIjqGfJvysASruv3N+LtfeUBQgmH3WOk+MXDafvWUXUJ
-- e3cROdNx+fjm1msL5x70uU7jTdauSC01RlNOZa7ia5d7w6+J9+MsucS5qeohFNLO
-- F52f3QjzNku+zb7Q1J3QewQnNxbDut/E6neM4TXlBMa2iG4ODDWlZI5SMb1BAlTd
-- JNqI+rl6Osfd8YsfFjmb5csH7f7F7Rl9xblL9VeUGkQ/dh8o1RImBs88D1iUsq63
-- Ca6jKTpUy/UDcnOKFxGZCLNWFpWulOrag0yon4mNpJGhpA54JvsX
-- -----END-SIGNATURE-----